﻿using log4net;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Data;
using VA.PPMS.IWS.Api.Helpers;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Api.Controllers
{
    [Route("[controller]/v1")]
    public class CcnDataStreamController : Controller
    {
        private readonly ILog _logger;
        private readonly IIwsConfiguration _configuration;
        private readonly IHttpClientHandler _client;

        public CcnDataStreamController(ILog logger, IIwsConfiguration configuration, IHttpClientHandler client)
        {
            _logger = logger;
            _configuration = configuration;
            _client = client;
        }

        [HttpPost]
        public async Task<IActionResult> Post([FromBody]string payload)
        {
            var message = DasHelper.ParseHeaders(Request);

            try
            {
                _logger.Info($"@@@@@ Info - Start POST for CcnDataStreamController: {message.ConversationId} @@@@@");

                using (var response = await _client.PostAsync(await _configuration.GetCcnDataStreamUri(), payload, message))
                {
                    _logger.Info($"---- CcnDataStreamController - Post to function complete");

                    if (response.IsSuccessStatusCode)
                    {
                        _logger.Info("@@@@@ Info - CcnDataStreamController POST successful. (201) @@@@@");

                        return StatusCode(StatusCodes.Status201Created, DasHelper.StatusCode201(message.ConversationId));
                    }

                    _logger.Error($"!!!! Unable to process Providers. There was an error posting to the Function API: {response}");
                    var error = await response.Content.ReadAsStringAsync();
                    _logger.Error($"!!!! CcnDataStreamController POST Exception (400). The error is {error}: {response}");

                    return StatusCode(StatusCodes.Status400BadRequest, DasHelper.StatusCode400(message.ConversationId, message.ReceiverId));
                }
            }
            catch (Exception ex)
            {
                _logger.Error($"CcnDataStreamController POST Exception (500): {ex} ");
                return StatusCode(StatusCodes.Status500InternalServerError, DasHelper.StatusCode500(message.ConversationId));
            }
        }
    }
}